/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments.flag;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.CuboidRegion;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class RegionFlagArgumentType
implements ArgumentType<String> {
    public static final Pattern VALID_FLAG_PATTERN = Pattern.compile("^[A-Za-z][A-Za-z\\-][A-Za-z]$");
    private static final Collection<String> EXAMPLES = RegionFlag.getFlagNames();
    private static final SimpleCommandExceptionType ERROR_AREA_INVALID = new SimpleCommandExceptionType((Message)class_2561.method_48321((String)"cli.arg.flag.parse.invalid", (String)"Unable to parse flag identifier!"));
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(flag -> class_2561.method_48322((String)"cli.arg.flag.invalid", (String)"Invalid flag identifier: '%s'", (Object[])new Object[]{flag}));

    public static RegionFlagArgumentType flag() {
        return new RegionFlagArgumentType();
    }

    public static RegionFlag getFlag(CommandContext<class_2168> ctx, String argName) throws CommandSyntaxException {
        String flagIdentifier = (String)ctx.getArgument(argName, String.class);
        if (RegionFlag.contains(flagIdentifier)) {
            return RegionFlag.fromId(flagIdentifier);
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)("Invalid flag identifier: '" + flagIdentifier + "'!")));
        throw ERROR_INVALID_VALUE.create((Object)flagIdentifier);
    }

    public static Set<RegionFlag> getFlags(CommandContext<class_2168> ctx, String argName) throws CommandSyntaxException {
        String flagIdentifiers = (String)ctx.getArgument(argName, String.class);
        HashSet<String> flagsList = new HashSet<String>(Arrays.asList(flagIdentifiers.split(" ")));
        Set<RegionFlag> regionFlags = flagsList.stream().filter(flag -> {
            if (RegionFlag.contains(flag)) {
                return true;
            }
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)("Invalid flag identifier: '" + flag + "'!")));
            return false;
        }).map(RegionFlag::fromId).collect(Collectors.toSet());
        if (regionFlags.isEmpty()) {
            throw ERROR_INVALID_VALUE.create((Object)flagIdentifiers);
        }
        return regionFlags;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && String.valueOf(reader.peek()).matches(Pattern.compile("^[A-Za-z\\d\\-]$").pattern())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            boolean isValidName = s.matches(VALID_FLAG_PATTERN.pattern());
            if (isValidName) {
                return s;
            }
            throw new IllegalArgumentException("Invalid flag identifier supplied");
        }
        catch (IllegalArgumentException argumentException) {
            reader.setCursor(i);
            Constants.LOGGER.error("Error parsing flag identifier");
            throw ERROR_AREA_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
        Object object = ctx.getSource();
        if (object instanceof class_2168) {
            class_2168 src = (class_2168)object;
            CuboidRegion region = (CuboidRegion)ArgumentUtil.getRegionArgument(ctx);
            List<String> flagNames = RegionFlag.getFlagNames();
            String input = ctx.getInput();
            if (input.contains("add")) {
                flagNames = flagNames.stream().filter(flagName -> !region.containsFlag((String)flagName)).collect(Collectors.toList());
            }
            if (input.contains("remove")) {
                flagNames = flagNames.stream().filter(region::containsFlag).collect(Collectors.toList());
            }
            if (flagNames.isEmpty()) {
                if (input.contains("add")) {
                    MessageSender.sendCmdFeedback(src, class_2561.method_43470((String)("There are no flag left to add for this region '" + region.getName() + "'.")));
                }
                if (input.contains("remove")) {
                    MessageSender.sendCmdFeedback(src, class_2561.method_43470((String)("Region '" + region.getName() + "' does not contain any flags.")));
                }
                return Suggestions.empty();
            }
            return class_2172.method_9265(flagNames, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }
}

